/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.upconversion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.upconversion.ElementWrapper;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionErrorCode;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionFailure;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionOptionDefinitions;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionOptions;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpConversionUtilities {
    public static final String UPCONVERSION_OPTIONS_XML_LOCAL_NAME = "upconversion-options";

    public static String getErrorMessage(UpConversionFailure failure) {
        return MessageFormatter.getErrorMessage((ErrorCode)failure.getErrorCode(), (Object[])failure.getArguments());
    }

    public static String getErrorMessage(String upConversionErrorCodeAsString, Object ... arguments) {
        UpConversionErrorCode errorCode;
        try {
            errorCode = UpConversionErrorCode.valueOf(upConversionErrorCodeAsString);
        }
        catch (IllegalArgumentException e) {
            throw new SnuggleLogicException("Could not look up UpConversionErrorCode " + upConversionErrorCodeAsString);
        }
        return MessageFormatter.getErrorMessage((ErrorCode)errorCode, (Object[])arguments);
    }

    public static UpConversionFailure extractUpConversionFailure(Element sFailElement) {
        UpConversionErrorCode errorCode;
        ConstraintUtilities.ensureNotNull((Object)sFailElement, (String)"sFailElement");
        if (!"http://www.ph.ed.ac.uk/snuggletex".equals(sFailElement.getNamespaceURI()) || !sFailElement.getLocalName().equals("fail")) {
            throw new IllegalArgumentException("Element is not an <s:fail/> element");
        }
        String codeAttribute = sFailElement.getAttribute("code");
        try {
            errorCode = UpConversionErrorCode.valueOf(codeAttribute);
        }
        catch (IllegalArgumentException e) {
            throw new SnuggleLogicException("Error code '" + codeAttribute + "' not defined");
        }
        NodeList childNodes = sFailElement.getChildNodes();
        ArrayList<String> arguments = new ArrayList<String>();
        String xPath = null;
        String context = null;
        int size = childNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            if (!"http://www.ph.ed.ac.uk/snuggletex".equals(child.getNamespaceURI())) {
                throw new SnuggleLogicException("Didn't expect child of <s:fail/> in namespace " + child.getNamespaceURI());
            }
            if (child.getLocalName().equals("arg")) {
                arguments.add(XMLUtilities.extractTextElementValue((Element)((Element)child)));
                continue;
            }
            if (child.getLocalName().equals("xpath")) {
                if (context != null) {
                    throw new SnuggleLogicException("Did not expect more than 1 <s:xpath/> element inside <s:fail/>");
                }
                xPath = XMLUtilities.extractTextElementValue((Element)((Element)child));
                continue;
            }
            if (child.getLocalName().equals("context")) {
                if (context != null) {
                    throw new SnuggleLogicException("Did not expect more than 1 <s:context/> element inside <s:fail/>");
                }
                context = MathMLUtilities.serializeElement((Element)((Element)child));
                continue;
            }
            throw new SnuggleLogicException("Didn't expect child of <s:fail/> with local name " + child.getLocalName());
        }
        if (context == null) {
            throw new SnuggleLogicException("No <s:context/> element found inside <s:fail/>");
        }
        return new UpConversionFailure(errorCode, xPath, context, arguments.toArray(new String[arguments.size()]));
    }

    public static List<UpConversionFailure> extractUpConversionFailures(Document upConvertedDocument) {
        return UpConversionUtilities.extractUpConversionFailures(upConvertedDocument.getDocumentElement());
    }

    public static List<UpConversionFailure> extractUpConversionFailures(Element startSearchElement) {
        ArrayList<UpConversionFailure> result = new ArrayList<UpConversionFailure>();
        UpConversionUtilities.walkDOM(startSearchElement, result);
        return result;
    }

    private static void walkDOM(Element searchElement, List<UpConversionFailure> resultBuilder) {
        if ("http://www.ph.ed.ac.uk/snuggletex".equals(searchElement.getNamespaceURI()) && searchElement.getLocalName().equals("fail")) {
            resultBuilder.add(UpConversionUtilities.extractUpConversionFailure(searchElement));
        } else {
            NodeList childNodes = searchElement.getChildNodes();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                UpConversionUtilities.walkDOM((Element)child, resultBuilder);
            }
        }
    }

    public static void appendUpConversionOptionsElement(Document document, Element containerElement, UpConversionOptions options, boolean applyDefaults) {
        block4: {
            Element optionsContainer;
            block3: {
                optionsContainer = UpConversionUtilities.appendSnuggleElement(document, containerElement, UPCONVERSION_OPTIONS_XML_LOCAL_NAME);
                if (options != null) break block3;
                if (!applyDefaults) break block4;
                for (Map.Entry<String, UpConversionOptionDefinitions.OptionValueDefinition> entry : UpConversionOptionDefinitions.OPTION_DEFINITIONS.entrySet()) {
                    String name = entry.getKey();
                    String defaultValue = entry.getValue().getDefaultValue();
                    Element optionElement = UpConversionUtilities.appendSnuggleElement(document, optionsContainer, "option");
                    optionElement.setAttribute("name", name);
                    optionElement.setAttribute("value", defaultValue);
                }
                break block4;
            }
            for (String name : UpConversionOptionDefinitions.OPTION_DEFINITIONS.keySet()) {
                if (!applyDefaults && !options.isOptionSpecified(name)) continue;
                String value = options.getEffectiveOptionValue(name, applyDefaults);
                Element optionElement = UpConversionUtilities.appendSnuggleElement(document, optionsContainer, "option");
                optionElement.setAttribute("name", name);
                optionElement.setAttribute("value", value);
            }
            for (ElementWrapper elementWrapper : options.getAssumedSymbols()) {
                String assumptionType = options.getSymbolAssumptionType(elementWrapper);
                Element assumeElement = UpConversionUtilities.appendSnuggleElement(document, optionsContainer, "symbol");
                assumeElement.setAttribute("assume", assumptionType);
                Node assumptionTargetCopy = elementWrapper.getSymbolElement().cloneNode(true);
                assumeElement.appendChild(assumptionTargetCopy);
            }
        }
    }

    private static Element appendSnuggleElement(Document document, Element parentElement, String localName) {
        return (Element)parentElement.appendChild(document.createElementNS("http://www.ph.ed.ac.uk/snuggletex", "s:" + localName));
    }
}

